<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\EmployeeOverTime;
use App\Models\EmployeeAdvance;
use App\Models\EmployeeAttendance;
use App\Models\EmployeeSalaries;

class Employee extends Model
{
    use HasFactory;

    public function overtime(){
        return $this->hasMany(EmployeeOverTime::class);
    }

    public function advance(){
        return $this->hasMany(EmployeeAdvance::class);
    }

    public function salary(){
        return $this->hasMany(EmployeeSalaries::class);
    }

    public function attendance(){
        return $this->hasMany(EmployeeAttendance::class);
    }
}
