<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\CustomerBill;
use App\Models\CustomerRecieved;
use App\Models\CustomerAdvance;

use App\Models\SupplierBill;
use App\Models\SupplierPayment;
use App\Models\SupplierAdvance;

use App\Models\CashJournal;
use App\Models\ExpenseJournal;
use App\Models\BankJournal;
use App\Models\DebitorJournal;
use App\Models\CompanyAsset;

class Currency extends Model
{
    use HasFactory;

    public function bills(){
        return $this->hasMany(CustomerBill::class);
    }

    public function customer_recieved(){
        return $this->hasMany(CustomerRecieved::class);
    }

    public function customer_advance(){
        return $this->hasMany(CustomerAdvance::class);
    }

    public function supplier_bill(){
        return $this->hasMany(SupplierBill::class);
    }

    public function supplier_payment(){
        return $this->hasMany(SupplierPayment::class);
    }

    public function supplier_advance(){
        return $this->hasMany(SupplierAdvance::class);
    }

    public function cash_journal(){
        return $this->hasMany(CashJournal::class);
    }
    public function expense_journal(){
        return $this->hasMany(ExpenseJournal::class);
    }
    public function bank_journal(){
        return $this->hasMany(BankJournal::class);
    }
    public function debitor_journal(){
        return $this->hasMany(DebitorJournal::class);
    }
    public function company_asset(){
        return $this->hasMany(CompanyAsset::class);
    }
}
