<?php

namespace App\Http\Controllers\saleAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerRetailBill;
use App\Models\Customer_retail_bill_item;
use App\Models\RetailNoStockItem;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\Stock;
use App\Models\Currency;
use App\Models\CashJournal;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class CustomerRetailBillController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bills = CustomerRetailBill::orderBy('id', 'desc')->paginate(10);
        return view('sale.retail_bills.index', compact('bills'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $currencies = Currency::all();
        $invoice_number = CustomerRetailBill::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('sale.retail_bills.bill-create', compact('currencies', 'number'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'invoice_number' => 'required',
            'currency_id' => 'required',
            'title' => 'required',
            'customer_name' => 'required',
            'customer_phone' => 'required',
        ]);
        $bill = new CustomerRetailBill();
        $bill->type_id = $request->type_id;
        $bill->invoice_date = $request->date;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->customer_name = $request->customer_name;
        $bill->customer_phone = $request->customer_phone;
        $bill->status = 0;
        $bill->save();
        if ($bill) {
            session()->flash("msg", "Success!");
            return redirect()->route('customer_retail_bill.next_create', $bill->id);
        }
    }

    public function next_create($id)
    {
        $bill_id = $id;
        $bill = CustomerRetailBill::find($bill_id);
        $customer_id = $bill->customer_id;
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        if ($bill->type_id == 1) {
            $bill_items = Customer_retail_bill_item::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();

        } else {
            $bill_items = RetailNoStockItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();

        }
        return view('sale.retail_bills.bill-create-next', compact('categories', 'subcategories', 'weights', 'units', 'bill_items', 'bill_id', 'customer_id', 'bill'));
    }

    public function item_store(Request $request)
    {
        $request->validate([
            'stock_id' => 'required',
            'bill_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'spi' => 'required',
            'cpi' => 'required',
            'qty' => 'required',
        ]);
        $items = new Customer_retail_bill_item();
        $items->bill_id = $request->bill_id;
        $items->stock_id = $request->stock_id;
        $items->cat_id = $request->cat_id;
        $items->sub_cat_id = $request->scat_id;
        $items->weight_id = $request->weight_id;
        $items->unit_id = $request->unit_id;
        $items->cost_price = $request->cpi;
        $items->sale_price = $request->sale_price;
        $items->qty = $request->qty;
        $items->total = $request->sale_price * $request->qty;
        $items->cost_total = $request->cpi * $request->qty;
        $items->date = $request->date;
        $items->save();
        if ($items) {
            $stock = Stock::find($request->stock_id);
            $qty = $stock->qty;
            $qty = $qty - $request->qty;
            $stock->qty = $qty;
            $stock->save();
        }
        session()->flash("msg", "Success!");
        return back()->with('mag', 'Success');
    }
    public function item_delete($id)
    {
        $item = Customer_retail_bill_item::find($id);
        $stock = Stock::find($item->stock_id);
        $qty = $stock->qty;
        $qty = $qty + $item->qty;
        $stock->qty = $qty;
        $stock->save();
        if ($stock) {
            $item->delete();
            session()->flash("msg", "Deleted SuccessFully!");
            return back();
        }

    }

    public function nositem_store(Request $request)
    {
        $item = new RetailNoStockItem();
        $item->bill_id = $request->bill_id;
        $item->name = $request->name;
        $item->price = $request->price;
        $item->qty = $request->qty;
        $item->total = $request->qty * $request->price;
        $item->save();
        session()->flash("msg", "Success!");
        return back();
    }
    public function nositem_delete($id)
    {
        $item = RetailNoStockItem::find($id);
        $item->delete();
        session()->flash("msg", "Success!");
        return back();

    }
    public function next_store(Request $request)
    {
        $request->validate([
            'grand_total' => 'required',
            'bill_discount' => 'required',
            'received' => 'required',
        ]);
        $bill = CustomerRetailBill::find($request->bill_id);
        $bill->grand_total = $request->grand_total;
        $bill->discount = $request->bill_discount;
        $final_amount = $request->grand_total - $request->bill_discount;
        $bill->final_amount = $final_amount;
        $bill->received = $request->received;
        if ($request->balance_value == "" || $request->balance_value == 0) {
            $bill->balance = $final_amount;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->received_by = $request->received_by;
        $bill->c_target = $request->cash_id;
        $bill->save();
        if ($bill) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $bill->title;
                $cash->date = $bill->invoice_date;
                $cash->income = $bill->received;
                $cash->currency_id = $bill->currency_id;
                $cash->ex_rate = $bill->ex_rate;
                $cash->module_id = 28;
                $cash->type_id = 28;
                $cash->module_record_id = $bill->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Targer From Retail Sale";
                $cash->save();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('customer_retail_bill.index');

    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function print($id)
    {
        $bill = CustomerRetailBill::find($id);
        if ($bill->type_id == 1) {
            $bill_items = Customer_retail_bill_item::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = RetailNoStockItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }
        return view('sale.retail_bills.print-bill', compact('bill', 'bill_items'));

    }
    public function show($id)
    {
        $bill = CustomerRetailBill::find($id);
        if ($bill->type_id == 1) {
            $bill_items = Customer_retail_bill_item::where('bill_id', $id)->get();
        } else {
            $bill_items = RetailNoStockItem::where('bill_id', $id)->get();
        }
        return view('sale.retail_bills.show', compact('bill', 'bill_items'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $bill = CustomerRetailBill::find($id);
        $bill_id = $id;
        $customer_id = $bill->customer_id;
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        if ($bill->type_id == 1) {
            $bill_items = Customer_retail_bill_item::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = RetailNoStockItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }
        $currencies = Currency::all();
        return view('sale.retail_bills.bill-edit', compact('bill_items', 'categories', 'subcategories', 'weights', 'units', 'bill_items', 'bill', 'currencies', 'bill_id', 'customer_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'grand_total' => 'required',
            'bill_discount' => 'required',
            'received' => 'required',
        ]);
        $bill = CustomerRetailBill::find($id);
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->customer_name = $request->customer_name;
        $bill->customer_phone = $request->customer_phone;
        $bill->grand_total = $request->grand_total;
        $bill->discount = $request->bill_discount;
        $final_amount = $request->grand_total - $request->bill_discount;
        $bill->final_amount = $final_amount;
        $bill->received = $request->received;
        if ($request->received == "" || $request->received == 0) {
            $bill->balance = $final_amount;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->received_by = $request->received_by;
        $bill->currency_id = $request->currency_id;
        $bill->c_target = $request->cash_id;
        $bill->save();
        if ($bill) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 28)->where('module_record_id', $bill->id)->first();
                if ($cash != null) {
                    $cash->title = $bill->title;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 28;
                    $cash->type_id = 28;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Targer Retails";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $bill->title;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 28;
                    $cash->type_id = 28;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Targer Retails";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 28)->where('module_record_id', $bill->id)->delete();

            }
            session()->flash("msg", "Updated Success!");
            return redirect()->route('customer_retail_bill.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function delete($id)
    {
        $bill = CustomerRetailBill::find($id);
        $bill_items = Customer_retail_bill_item::where('bill_id', $id)->get();
        foreach ($bill_items as $row) {
            $stock = Stock::find($row->stock_id);
            $qty = $row->qty;
            $stock->qty = $qty + $stock->qty;
            $stock->save();
        }
        Customer_retail_bill_item::where('bill_id', $id)->delete();
        $cash = CashJournal::where('module_id', 28)->where('module_record_id', $bill->id)->delete();
        $bill->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function report_show()
    {
        $currencies = Currency::all();
        return view('sale.retail_bills.report', compact('currencies'));
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $currency_id = $request->currency_id;
        $currency = Currency::find($currency_id);
        $currencies = currency::all();
        $data = "";
        if ($request->customer_name == "0") {
            if ($currency_id == "all") {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Retail Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>All Currency</h6>";
                $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>LO</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>phone</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>CUR</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerRetailBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('created_at', 'asc')->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer_name . "</td>";
                    $data .= "<td>" . $row->customer_phone . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tbody>";
                $data .= ' <tr>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Recieved</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td>' . $row->title_en . "/" . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $customer_bill->where('currency_id', $row->id)->sum('received');
                    $data .= '<td>' . $row->title_en . "/" . $recieved . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->sum('final_amount');
                    $recieved = $customer_bill->where('currency_id', $row->id)->sum('received');
                    $balance = $total - $recieved;
                    $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            } else {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>NO</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>Phone</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                if ($currency_id != 1) {
                    $data .= '<th>ERate</th>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerRetailBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->orderBy('created_at', 'asc')->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer_name . "</td>";
                    $data .= "<td>" . $row->customer_phone . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    if ($currency_id != 1) {
                        $data .= "<td>" . $row->ex_rate . "</td>";
                    }
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Recieved</th>';
                $data .= '<th colspan="4">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $customer_bill->sum('final_amount') . '</th>';
                $data .= '<th colspan="2">' . $customer_bill->sum('recieved') . '</th>';
                $balance = $customer_bill->sum('final_amount') - $customer_bill->sum('recieved');
                $data .= '<th colspan="4">' . $balance . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            }

        } else {

            if ($currency_id == "all") {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Retail Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>All Currency</h6>";
                $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th ># Number</th>';
                $data .= '<th>Customer Name</th>';
                $data .= '<th>Customer phone</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerRetailBill::whereBetween('invoice_date', [$fDate, $tDate])->where('customer_name', 'like', '%' . $request->customer_name . '%')->orderBy('created_at', 'asc')->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer_name . "</td>";
                    $data .= "<td>" . $row->customer_phone . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tbody>";
                $data .= ' <tr>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Recieved</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td>' . $row->title_en . "/" . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $customer_bill->where('currency_id', $row->id)->sum('received');
                    $data .= '<td>' . $row->title_en . "/" . $recieved . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->sum('final_amount');
                    $recieved = $customer_bill->where('currency_id', $row->id)->sum('received');
                    $balance = $total - $recieved;
                    $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            } else {

                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Customer_name</th>';
                $data .= '<th>Customer_phone</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                if ($currency_id != 1) {
                    $data .= '<th>ERate</th>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerRetailBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->where('customer_name', 'like', '%' . $request->customer_name . '%')->orderBy('created_at', 'asc')->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer_name . "</td>";
                    $data .= "<td>" . $row->customer_phone . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    if ($currency_id != 1) {
                        $data .= "<td>" . $row->ex_rate . "</td>";
                    }
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Recieved</th>';
                $data .= '<th colspan="4">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $customer_bill->sum('final_amount') . '</th>';
                $data .= '<th colspan="2">' . $customer_bill->sum('recieved') . '</th>';
                $balance = $customer_bill->sum('final_amount') - $customer_bill->sum('recieved');
                $data .= '<th colspan="4">' . $balance . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            }
        }

        return $data;
    }
    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $bills = CustomerRetailBill::Where('invoice_number', $request->number)
                ->get();
        }
        if ($request->type_id == 2) {
            $bills = CustomerRetailBill::Where('title', 'like', '%' . $request->title . '%')
                ->get();
        }
        if ($request->type_id == 3) {
            $bills = CustomerRetailBill::Where('customer_name', 'like', '%' . $request->name . '%')
                ->get();
        }
        if ($request->type_id == 4) {
            $bills = CustomerRetailBill::Where('customer_phone', 'like', '%' . $request->phone . '%')
                ->get();
        }
        if ($request->type_id == 5) {
            $bills = CustomerRetailBill::whereBetween('invoice_date', [$request->f_date, $request->t_date])
                ->get();
        }
        return view('sale.retail_bills.filter', compact('bills'));
    }

}
