<?php

namespace App\Http\Controllers\saleAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Currency;
use App\Models\CustomerRecieved;
use App\Models\CashJournal;
use App\Models\CustomerBill;
use App\Models\CustomerLiger;

use Auth;


class CustomerRecievedController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $data = CustomerRecieved::orderBy('id', 'desc')->paginate(10);
        $customers = Customer::all();
        $currencies = Currency::all();
        return view('sale.receiveds.index', compact('data', 'customers', 'currencies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $customers = Customer::all();
        $currencies = Currency::all();
        $invoice_number = CustomerRecieved::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->recieved_number + 1;
        }
        return view('sale.receiveds.create', compact('customers', 'currencies', 'number'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'invoice_number' => 'required',
            'amount' => 'required',
            'customer_id' => 'required',
        ]);
        $data = new CustomerRecieved();
        $data->title = $request->title;
        $data->recieved_number = $request->invoice_number;
        $data->amount = $request->amount;
        $data->date = $request->date;
        $data->currency_id = $request->currency_id;
        $data->ex_rate = $request->ex_rate;
        $data->customer_id = $request->customer_id;
        $data->transaction_id = $request->transaction_id;
        $data->c_target = $request->cash_id;
        $data->details = $request->details;
        $data->save();
        if ($data) {
            $lidger = new CustomerLiger();
            $lidger->customer_id = $data->customer_id;
            $lidger->currency_id = $data->currency_id;
            $lidger->transaction_id = 2;
            $lidger->module_rid = $data->id;
            $lidger->bill_total = 0;
            $lidger->amount = $data->amount;
            $lidger->bill_balance = 0;
            // here we find related customer balance 
            $previouse_balance = CustomerLiger::where('customer_id', $data->customer_id)
                ->where('currency_id', $data->currency_id)
                ->orderBy('id', 'desc')
                ->get()->first();
            $total_balance = 0;
           
            if ($previouse_balance) {
                $previouse_balance = $previouse_balance->total_balance;
                $total_balance = $previouse_balance - $request->amount;
                $previouse_balance;
            } else {
                $total_balance = $total_balance - $data->amount;
            }
            $lidger->total_balance = $total_balance;
            $lidger->date = $data->date;
            $lidger->save();
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $data->title . " Invoice" . $data->recieved_number;
                $cash->date = $data->date;
                $cash->income = $data->amount;
                $cash->currency_id = $data->currency_id;
                $cash->ex_rate = $data->ex_rate;
                if ($data->transaction_id == 4) {
                    $cash->module_id = 33;
                    $cash->type_id = 33;
                } else {
                    $cash->module_id = 20;
                    $cash->type_id = 20;
                }

                $cash->module_record_id = $data->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Targer From Received";
                $cash->save();
            }
        }

        session()->flash("msg", "Success!");
        return redirect()->route('customer_recieved.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = CustomerRecieved::find($id);
        $customers = Customer::all();
        $currencies = currency::all();
        return view('sale.receiveds.edit', compact('data', 'customers', 'currencies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = CustomerRecieved::find($id);
        $data->title = $request->title;
        $data->recieved_number = $request->invoice_number;
        $data->amount = $request->amount;
        $data->date = $request->date;
        $data->currency_id = $request->currency_id;
        $data->ex_rate = $request->ex_rate;
        $data->customer_id = $request->customer_id;
        $data->transaction_id = $request->transaction_id;
        $data->c_target = $request->cash_id;
        $data->details = $request->details;
        $data->save();
       
        if ($request->cash_id == 1) {
            $cash = CashJournal::where('module_id', 20)->where('module_record_id', $data->id)->first();
            if ($cash != null) {
                $cash->title = $data->title . " Invoice" . $data->invoice_number;
                $cash->date = $data->date;
                $cash->income = $data->amount;
                $cash->currency_id = $data->currency_id;
                if ($data->transaction_id == 4) {
                    $cash->module_id = 33;
                    $cash->type_id = 33;
                } else {
                    $cash->module_id = 20;
                    $cash->type_id = 20;
                }

                $cash->module_record_id = $data->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Targer From Received";
                $cash->save();
            } else {
                $cash = new CashJournal();
                $cash->title = $data->title . " Invoice" . $data->invoice_number;
                $cash->date = $data->date;
                $cash->income = $data->amount;
                $cash->currency_id = $data->currency_id;
                $cash->module_id = 20;
                $cash->type_id = 20;
                $cash->module_record_id = $data->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Targer From Received";
                $cash->save();
            }
        } else {
            $cash = CashJournal::where('module_id', 20)->where('module_record_id', $data->id)->delete();
        }
        $lidger = CustomerLiger::where('transaction_id', 2)
        ->where('module_rid', $data->id)
        ->where('customer_id', $data->customer_id)
        ->where('currency_id', $data->currency_id)
        ->delete();
        $lidger = new CustomerLiger();
        $lidger->customer_id = $data->customer_id;
        $lidger->currency_id = $data->currency_id;
        $lidger->transaction_id = 2;
        $lidger->module_rid = $data->id;
        $lidger->bill_total = 0;
        $lidger->amount = $data->amount;
        $lidger->bill_balance = 0;
        // here we find related customer balance 
        $previouse_balance = CustomerLiger::where('customer_id', $data->customer_id)
            ->where('currency_id', $data->currency_id)
            ->orderBy('id', 'desc')
            ->get()->first();
        $total_balance = 0;
       
        if ($previouse_balance) {
            $previouse_balance = $previouse_balance->total_balance;
            $total_balance = $previouse_balance - $request->amount;
            $previouse_balance;
        } else {
            $total_balance = $total_balance - $data->amount;
        }
        $lidger->total_balance = $total_balance;
        $lidger->date = $data->date;
        $lidger->save();
        session()->flash("msg", "Success!");
        return redirect()->route('customer_recieved.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $data = CustomerRecieved::find($id);
        $data->delete();
        $lidger = CustomerLiger::where('transaction_id', 2)
        ->where('module_rid', $data->id)
        ->where('customer_id', $data->customer_id)
        ->where('currency_id', $data->currency_id)
        ->delete();
        $cash = CashJournal::where('module_id', 20)->where('module_record_id', $id)->delete();
        return back();
    }


    public function report_show()
    {
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = currency::all();
        return view('sale.receiveds.report', compact('customers', 'currencies'));
    }
    public function report_find(Request $request)
    {

        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $Customer = Customer::find($customer_id);
        $currency = currency::find($currency_id);
        $data = "";
        if ($customer_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>Recieved Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>All Customers & All Curencies</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $Recieveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->get();
                foreach ($Recieveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="foot">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">Recieved</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (currency::all() as $row) {
                    $Recieved = CustomerRecieved::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $Recieved . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'> Recieved Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $Recieveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->where('currency_id', $currency_id)->get();
                foreach ($Recieveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="foot">';
                $data .= ' <tr>';
                $data .= '<th colspan="4" class="">Recieved</th>';
                $data .= '<th colspan="4" class="">' . $Recieveds->sum('amount') . '</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';

                $data .= '</tr>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $Recieveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->name Recieved Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";

                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($Recieveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="foot">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">Recieved</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $Recieved = CustomerRecieved::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $Recieved . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $Recieveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->where('currency_id', $currency_id)->get();
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->name Recieved Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en currency</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($Recieveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="foot">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">' . $Recieveds->sum('amount') . '</th>';
                $data .= ' </tr>';

                $data .= '</table>';
            }

        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $data = CustomerRecieved::Where('recieved_number', $request->number)
                ->get();
        } else if ($request->type_id == 2) {
            $data = CustomerRecieved::Where('title', 'like', '%' . $request->amount . '%')
                ->get();
        } else {
            $data = CustomerRecieved::whereBetween('date', [$request->f_date, $request->t_date])
                ->get();
        }
        $customers = Customer::all();
        return view('sale.receiveds.filter', compact('data', 'customers'));
    }

    public function recipt($id)
    {
        $data = CustomerRecieved::find($id);
        $invoices = CustomerBill::where('customer_id', $data->customer_id)->where('currency_id', $data->currency_id)->sum('grand_total');
        $recieved = CustomerRecieved::where('customer_id', $data->customer_id)->where('currency_id', $data->currency_id)->sum('amount');
        $tbalance = $invoices - $recieved;
        return view('sale.receiveds.invoice', compact('data', 'tbalance'));

    }
}
