<?php
namespace App\Http\Controllers\saleAdministration;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Models\CustomerBill;
use App\Models\CustomerBillItem;
use App\Models\customerBillRowItem;
use App\Models\Customer;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\Stock;
use App\Models\PurchaseStock;
use App\Models\CustomerRecieved;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\CashJournal;
use App\Models\CustomerLiger;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class CustomerBillController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bills = CustomerBill::orderBy('created_at', 'desc')->paginate(10);
        return view('sale.bills.index', compact('bills'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = Currency::all();
        $invoice_number = CustomerBill::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('sale.bills.bill-create', compact('customers', 'currencies', 'number'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'invoice_number' => 'required',
            'customer_id' => 'required',
            'currency_id' => 'required',
            'title' => 'required',
        ]);
        $bill = new CustomerBill();
        $bill->invoice_date = $request->date;
        $bill->type_id = $request->type_id;
        $bill->customer_id = $request->customer_id;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->status = 0;
        $bill->user_id = Auth::user()->id;
        $date = date("Y-m-d");
        if (request()->hasFile('invoice_file')) {
            $filename = 'invoice_file-' . time() . '-' . request()->file('invoice_file')->getClientOriginalName();
            $path = request()->file('invoice_file')->storeAs('invoice_file/' . $date . '/', $filename, 'public');
        } else {
            $path = "invoice_file/noimage.jpg";
        }
        $bill->invoice_file = $path;
        $bill->save();
        if ($bill) {
            return redirect()->route('customer_bill.next_create', $bill->id);
        }
    }

    public function next_create($id)
    {
        $bill_id = $id;
        $bill = CustomerBill::find($id);
        $customer_id = CustomerBill::find($bill_id)->customer_id;
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        }
        $pcategories = PCategory::all();
        $punits = PUnit::all();
        return view('sale.bills.bill-create-next', compact('categories', 'pcategories', 'punits', 'subcategories', 'weights', 'units', 'bill_items', 'bill_id', 'customer_id', 'bill'));
    }

    public function item_store(Request $request)
    {
        $request->validate([
            'stock_id' => 'required',
            'bill_id' => 'required',
            'customer_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'cpi' => 'required',
            'qty' => 'required',
        ]);
        $items = new CustomerBillItem();
        $items->customer_id = $request->customer_id;
        $items->bill_id = $request->bill_id;
        $items->stock_id = $request->stock_id;
        $items->cat_id = $request->cat_id;
        $items->sub_cat_id = $request->scat_id;
        $items->weight_id = $request->weight_id;
        $items->unit_id = $request->unit_id;
        $items->cost_price = $request->cpi;
        $items->sale_price = $request->sale_price;
        $items->qty = $request->qty;
        $items->total = $request->sale_price * $request->qty;
        $items->cost_total = $request->cpi * $request->qty;
        $items->date = $request->date;
        $items->save();
        if ($items) {
            $stock = Stock::find($request->stock_id);
            $quantity = $stock->qty;
            $quantity = $quantity - $request->qty;
            $stock->qty = $quantity;
            $stock->save();
        }
        return back()->with('mag', 'Success');
    }

    public function item_edit($id)
    {
        $item = CustomerBillItem::find($id);
        $stock = Stock::find($item->stock_id);
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        return view('sale.bills.item-edit', compact('categories', 'subcategories', 'weights', 'units', 'item', 'stock'));

    }

    public function item_update(Request $request, $id)
    {
        $request->validate([
            'stock_id' => 'required',
            'weight_id' => 'required',
            'qty' => 'required',
        ]);
        $items = CustomerBillItem::find($id);
        $stock = Stock::find($items->stock_id);
        $quantity = $stock->qty;
        $quantity = $quantity + $items->qty;
        $stock->qty = $quantity;
        $stock->save();
        $items->stock_id = $request->stock_id;
        $items->cat_id = $request->cat_id;
        $items->weight_id = $request->weight_id;
        $items->sale_price = $request->sale_price;
        $items->qty = $request->qty;
        $items->total = $request->sale_price * $request->qty;
        $items->save();
        if ($items) {
            $stock = Stock::find($request->stock_id);
            $quantity = $stock->qty;
            $quantity = $quantity - $request->qty;
            $stock->qty = $quantity;
            $stock->save();
        }
        $bill_id = $items->bill_id;
        $customer_id = $items->customer_id;
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        $bill = CustomerBill::find($items->bill_id);
        $bill_items = CustomerBillItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        return view('sale.bills.bill-create-next', compact('categories', 'subcategories', 'weights', 'units', 'bill_items', 'bill_id', 'customer_id', 'bill'));
    }
    public function item_delete($id)
    {
        $item = CustomerBillItem::find($id);
        $stock = Stock::find($item->stock_id);
        $quantity = $stock->qty;
        $quantity = $quantity + $item->qty;
        $stock->qty = $quantity;
        $stock->save();
        if ($stock) {
            $item->delete();
            session()->flash("msg", "Deleted SuccessFully!");
            return back();
        }

    }
    // row item process

    public function row_item_store(Request $request)
    {
        $request->validate([
            'rstock_id' => 'required',
            'bill_id' => 'required',
            'customer_id' => 'required',
            'rcat_id' => 'required',
            'runit_id' => 'required',
            'rqty' => 'required',
        ]);
        $scat_id = PurchaseStock::find($request->rstock_id)->scat_id;
        $items = new customerBillRowItem();
        $items->customer_id = $request->customer_id;
        $items->bill_id = $request->bill_id;
        $items->stock_id = $request->rstock_id;
        $items->cat_id = $request->rcat_id;
        $items->scat_id = $scat_id;
        $items->unit_id = $request->runit_id;
        $items->cpi = $request->rcpi;
        $items->spi = $request->rspi;
        $items->qty = $request->rqty;
        $items->total = $request->rcpi * $request->rqty;
        $items->cost_total = $request->rcpi * $request->rqty;
        $items->date = date('Y-m-d');
        $items->save();
        if ($items) {
            $stock = PurchaseStock::find($request->rstock_id);
            $quantity = $stock->qty;
            $quantity = $quantity - $request->rqty;
            $stock->qty = $quantity;
            $stock->save();
        }
        session()->flash("msg", "Success!");
        return back();
    }
    public function row_item_delete($id)
    {
        $item = customerBillRowItem::find($id);
        $stock = PurchaseStock::find($item->stock_id);
        $quantity = $stock->qty;
        $quantity = $quantity + $item->qty;
        $stock->qty = $quantity;
        $stock->save();
        if ($stock) {
            $item->delete();
            session()->flash("msg", "Deleted SuccessFully!");
            return back();
        }

    }
    public function next_store(Request $request)
    {
        $request->validate([
            'grand_total' => 'required',
            'bill_discount' => 'required',
            'received' => 'required',
        ]);
        $bill = CustomerBill::find($request->bill_id);
        $bill->grand_total = $request->grand_total;
        $bill->discount = $request->bill_discount;
        $final_amount = $request->grand_total - $request->bill_discount;
        $bill->final_amount = $final_amount;
        $bill->received = $request->received;
        if ($request->received == 0 || $request->received == null) {
            $bill->balance = $final_amount;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->received_by = $request->received_by;
        $bill->transaction_id = $request->transaction_id;
        $bill->c_target = $request->cash_id;
        $bill->save();
        if ($bill) {
            $lidger = new CustomerLiger();
            $lidger->customer_id = $bill->customer_id;
            $lidger->currency_id = $bill->currency_id;
            $lidger->transaction_id = 1;
            $lidger->module_rid = $bill->id;
            $lidger->bill_total = $bill->final_amount;
            $lidger->amount = $bill->received;
            $lidger->bill_balance = $bill->final_amount - $bill->received;
            // here we find related customer balance 
            $previouse_balance = CustomerLiger::where('customer_id', $bill->customer_id)
                ->where('transaction_id', 1)
                ->where('currency_id', $bill->currency_id)
                    ->orderBy('id','desc')
                ->get()->first();
            $total_balance = 0;
            if ($previouse_balance) {
                $previouse_balance = $previouse_balance->total_balance;
                $total_balance = $previouse_balance + ($bill->final_amount - $bill->received);
            } else {
                $total_balance = $bill->final_amount - $bill->received;
            }
            $lidger->total_balance = $total_balance;
            $lidger->date = $bill->invoice_date;
            $lidger->save();
            if ($request->received != 0) {
                $recieved = new CustomerRecieved();
                $recieved->customer_id = $bill->customer_id;
                $recieved->currency_id = $bill->currency_id;
                $recieved->ex_rate = $bill->ex_rate;
                $recieved->bill_id = $bill->id;
                $recieved->details = "Recieved Amount is Added From " . $bill->invoice_number;
                $recieved->title = "from Bill " . $bill->invoice_number;
                $recieved->amount = $request->received;
                $recieved->recieved_number = $bill->invoice_number;
                $recieved->date = $bill->invoice_date;
                $recieved->status = 1;
                $recieved->save();
                if ($request->cash_id == 1) {
                    $cash = new CashJournal();
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->ex_rate = $bill->ex_rate;
                    $cash->module_id = 19;
                    $cash->type_id = 19;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Is Targeted From Bill Recieved";
                    $cash->save();
                }

            }
            session()->flash("msg", "Success!");
            return redirect()->route('customer_bill.index');
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function show($id)
    {
        $bill = CustomerBill::find($id);
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }
        return view('sale.bills.show', compact('bill', 'bill_items'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $bill_items = CustomerBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        $bill = CustomerBill::find($id);
        $bill_id = $id;
        $customer_id = $bill->customer_id;
        $customers = Customer::orderBy('id', 'desc')->get();
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        $currencies = Currency::all();
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();

        }
        $pcategories = PCategory::all();
        $punits = PUnit::all();
        return view('sale.bills.bill-edit', compact('bill_items', 'categories', 'subcategories', 'weights', 'units', 'bill_items', 'bill', 'customers', 'currencies', 'bill_id', 'customer_id', 'pcategories', 'punits'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'grand_total' => 'required',
            'bill_discount' => 'required',
            'received' => 'required',
        ]);
        $bill = CustomerBill::find($id);
        $bill->type_id = $request->type_id;
        $bill->customer_id = $request->customer_id;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->grand_total = $request->grand_total;
        $bill->discount = $request->bill_discount;
        $final_amount = $request->grand_total - $request->bill_discount;
        $bill->final_amount = $final_amount;
        $bill->received = $request->received;
        $bill->c_target = $request->cash_id;
        if ($request->received == 0 || $request->received == null) {
            $bill->balance = $final_amount;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->received_by = $request->received_by;
        $bill->currency_id = $request->currency_id;
        $bill->transaction_id = $request->transaction_id;
        $date = date("Y-m-d");
        if (request()->hasFile('invoice_file')) {
            $filename = 'invoice_file-' . time() . '-' . request()->file('invoice_file')->getClientOriginalName();
            $path = request()->file('invoice_file')->storeAs('invoice_file/' . $date . '/', $filename, 'public');
        } else {
            $path = $bill->invoice_file;
        }
        $bill->invoice_file = $path;
        $bill->user_id = Auth::user()->id;
        $bill->save();
        if ($bill) {
            $recieved_recieved_table = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->first();
            if ($recieved_recieved_table != null) {
                $lidger = CustomerLiger::where('transaction_id', 2)->where('module_rid', $recieved_recieved_table->id)->delete();
                $recieved_recieved_table = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->delete();
                if ($request->received != 0) {
                    $recieved = new CustomerRecieved();
                    $recieved->customer_id = $bill->customer_id;
                    $recieved->currency_id = $bill->currency_id;
                    $recieved->bill_id = $bill->id;
                    $recieved->details = "Recieved Amount is Added From" . $bill->invoice_number;
                    $recieved->amount = $request->received;
                    $recieved->title = "from Bill " . $bill->invoice_number;
                    $recieved->recieved_number = $bill->invoice_number;
                    $recieved->date = $bill->invoice_date;
                    $recieved->status = 1;
                    $recieved->save();
                    
                }
            } else {
                if ($request->received != 0) {
                    $recieved = new CustomerRecieved();
                    $recieved->customer_id = $bill->customer_id;
                    $recieved->currency_id = $bill->currency_id;
                    $recieved->bill_id = $bill->id;
                    $recieved->details = "Recieved Amount is Added From " . $bill->bill_no;
                    $recieved->amount = $request->received;
                    $recieved->recieved_number = $bill->invoice_number;
                    $recieved->title = "from Bill " . $bill->invoice_number;
                    $recieved->date = $bill->invoice_date;
                    $recieved->status = 1;
                    $recieved->save();
                   
                }
            }

            $lidger = CustomerLiger::where('transaction_id', 1)
                ->where('module_rid', $bill->id)
                ->where('customer_id', $bill->customer_id)
                ->delete();
            //  then entry new item 
            if ($lidger) {
                $lidger = new CustomerLiger();
                $lidger->customer_id = $bill->customer_id;
                $lidger->currency_id = $bill->currency_id;
                $lidger->transaction_id = 1;
                $lidger->module_rid = $bill->id;
                $lidger->bill_total = $bill->final_amount;
                $lidger->amount = $bill->received;
                $lidger->bill_balance = $bill->final_amount - $bill->received;
                // here we find related customer balance 
                $previouse_balance = CustomerLiger::where('customer_id', $bill->customer_id)
                    ->where('transaction_id', 1)
                    ->where('currency_id', $bill->currency_id)
                    ->orderBy('id','desc')
                    ->get()->first();
                $total_balance = 0;
                if ($previouse_balance) {
                    $previouse_balance = $previouse_balance->total_balance;
                    $total_balance = $previouse_balance + ($bill->final_amount - $bill->received);
                } else {
                    $total_balance = $bill->final_amount - $bill->received;
                }
                $lidger->total_balance = $total_balance;
                $lidger->date = $bill->invoice_date;
                $lidger->save();
            }


            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 19)->where('module_record_id', $bill->id)->first();
                if ($cash != null) {
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->ex_rate = $bill->ex_rate;
                    $cash->module_id = 19;
                    $cash->type_id = 19;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Is Targeted From Bill Recieved";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 19;
                    $cash->type_id = 19;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Is Targeted From Bill Recieved";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 19)->where('module_record_id', $bill->id)->delete();
            }


            session()->flash("msg", "Updated Success!");
            return redirect()->route('customer_bill.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function delete($id)
    {
        $bill = CustomerBill::find($id);
        $bill_items = CustomerBillItem::where('bill_id', $id)->get();
        foreach ($bill_items as $row) {
            $stock = Stock::find($row->stock_id);
            $qty = $row->qty;
            $stock->qty = $qty + $stock->qty;
            $stock->save();
        }
        CustomerBillItem::where('bill_id', $id)->delete();
        $recieved = CustomerRecieved::where('bill_id', $id)->delete();
        $cash = CashJournal::where('module_id', 1)->where('module_record_id', $bill->id)->delete();
        $lidger = CustomerLiger::where('transaction_id', 1)
                ->where('module_rid', $id)
                
                ->delete();
        $bill->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function print($id)
    {
        $bill = CustomerBill::find($id);
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }

        $customer = Customer::find($bill->customer_id);
        $sale = CustomerBill::where('customer_id', $customer->id)->where('currency_id', $bill->currency_id)->sum('final_amount');
        $received = CustomerRecieved::where('customer_id', $customer->id)->where('currency_id', $bill->currency_id)->sum('amount');
        $dev_rec = $received - $bill->received;
        $dev_sale = $sale - $bill->final_amount;
        $dev_amount = $dev_sale - $dev_rec;
        $t_balance = $sale - $received;

        return view('sale.bills.print-bill', compact('bill', 'bill_items', 'customer', 't_balance', 'dev_amount'));

    }

    public function report_show()
    {
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = Currency::all();
        return view('sale.bills.report', compact('customers', 'currencies'));
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $customer = Customer::find($customer_id);
        $currency = Currency::find($currency_id);
        $currencies = currency::all();
        $data = "";
        if ($customer_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>All Customer & All Currency</h6>";
                $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th ># Number</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('created_at', 'asc')->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $balance = $row->grand_total - $row->received;
                    $data .= "<td>" . $balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tbody>";
                $data .= ' <tr>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Recieved</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td>' . $row->title_en . "/" . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $customer_bill->where('currency_id', $row->id)->sum('received');
                    $data .= '<td>' . $row->title_en . "/" . $recieved . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->sum('final_amount');
                    $recieved = $customer_bill->where('currency_id', $row->id)->sum('received');
                    $balance = $total - $recieved;
                    $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            } else {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                if ($currency_id != 1) {
                    $data .= '<th>ERate</th>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->orderBy('created_at', 'asc')->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $balance = $row->grand_total - $row->received;
                    $data .= "<td>" . $balance . "</td>";
                    if ($currency_id != 1) {
                        $data .= "<td>" . $row->ex_rate . "</td>";
                    }
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Recieved</th>';
                $data .= '<th colspan="4">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $customer_bill->sum('final_amount') . '</th>';
                $data .= '<th colspan="2">' . $customer_bill->sum('recieved') . '</th>';
                $balance = $customer_bill->sum('final_amount') - $customer_bill->sum('recieved');
                $data .= '<th colspan="4">' . $balance . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $balance = $row->grand_total - $row->received;
                    $data .= "<td>" . $balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }


                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tbody>";
                $data .= ' <tr>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Recieved</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('final_amount');
                    $data .= '<td>' . $row->title_en . "/" . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('received');
                    $data .= '<td>' . $row->title_en . "/" . $recieved . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('final_amount');
                    $recieved = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('received');
                    $balance = $total - $recieved;
                    $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            } else {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $balance = $row->grand_total - $row->received;
                    $data .= "<td>" . $balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Recieved</th>';
                $data .= '<th colspan="3">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $customer_bill->sum('final_amount') . '</th>';
                $data .= '<th colspan="2">' . $customer_bill->sum('received') . '</th>';
                $balance = $customer_bill->sum('final_amount') - $customer_bill->sum('received');
                $data .= '<th colspan="3">' . $balance . '</th>';
                $data .= "</tr>";

                $data .= "</tbody>";
                $data .= '</table>';

            }
        }

        return $data;
    }
    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $bills = CustomerBill::Where('invoice_number', $request->number)
                ->get();
        } else if ($request->type_id == 2) {
            $bills = CustomerBill::Where('title', 'like', '%' . $request->title . '%')
                ->get();
        } else {
            $bills = CustomerBill::whereBetween('invoice_date', [$request->f_date, $request->t_date])
                ->get();
        }
        return view('sale.bills.filter', compact('bills'));
    }

    public function simple_print($id)
    {
        $bill = CustomerBill::find($id);
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }

        $customer = Customer::find($bill->customer_id);
        $sale = CustomerBill::where('customer_id', $customer->id)->where('currency_id', $bill->currency_id)->sum('final_amount');
        $received = CustomerRecieved::where('customer_id', $customer->id)->where('currency_id', $bill->currency_id)->sum('amount');
        $dev_rec = $received - $bill->received;
        $dev_sale = $sale - $bill->final_amount;
        $dev_amount = $dev_sale - $dev_rec;
        $t_balance = $sale - $received;

        return view('sale.bills.invoice', compact('bill', 'bill_items', 'customer', 't_balance', 'dev_amount'));

    }





}
