<?php

namespace App\Http\Controllers\saleAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Currency;
use App\Models\CustomerAdvance;
use App\Models\CashJournal;
use App\Models\CustomerLiger;
use Auth;

class CustomerAdvanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = CustomerAdvance::orderBy('id', 'desc')->paginate(10);
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = currency::all();
        return view('sale.advances.index', compact('data', 'customers', 'currencies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = currency::all();
        $invoice_number = CustomerAdvance::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('sale.advances.create', compact('customers', 'currencies', 'number'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'invoice_number' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
            'customer_id' => 'required',
        ]);
        $data = new CustomerAdvance();
        $data->title = $request->title;
        $data->invoice_number = $request->invoice_number;
        $data->amount = $request->amount;
        $data->date = $request->date;
        $data->currency_id = $request->currency_id;
        $data->ex_rate = $request->ex_rate;
        $data->customer_id = $request->customer_id;
        $data->details = $request->details;
        $data->c_target = $request->cash_id;

        $data->save();
        if ($data) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $data->title;
                $cash->date = $data->date;
                $cash->income = $data->amount;
                $cash->currency_id = $data->currency_id;
                $cash->ex_rate = $data->ex_rate;
                $cash->module_id = 30;
                $cash->type_id = 30;
                $cash->module_record_id = $data->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Target From Customer Advance";
                $cash->save();
            }
        }
        $lidger = new CustomerLiger();
        $lidger->customer_id = $data->customer_id;
        $lidger->currency_id = $data->currency_id;
        $lidger->transaction_id = 4;
        $lidger->module_rid = $data->id;
        $lidger->bill_total = 0;
        $lidger->amount = $data->amount;
        $lidger->bill_balance = 0;
        // here we find related customer balance 
        $previouse_balance = CustomerLiger::where('customer_id', $data->customer_id)
            ->where('currency_id', $data->currency_id)
            ->orderBy('id', 'desc')
            ->get()->first();
        $total_balance = 0;

        if ($previouse_balance) {
            $previouse_balance = $previouse_balance->total_balance;
            $total_balance = $previouse_balance - $request->amount;
            $previouse_balance;
        } else {
            $total_balance = $total_balance - $data->amount;
        }
        $lidger->total_balance = $total_balance;
        $lidger->date = $data->date;
        $lidger->save();
        session()->flash("msg", "Success!");
        return redirect()->route('customer_advance.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = currency::all();
        $data = CustomerAdvance::find($id);
        return view('sale.advances.edit', compact('customers', 'currencies', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = CustomerAdvance::find($id);
        $data->title = $request->title;
        $data->invoice_number = $request->invoice_number;
        $data->amount = $request->amount;
        $data->date = $request->date;
        $data->currency_id = $request->currency_id;
        $data->ex_rate = $request->ex_rate;
        $data->customer_id = $request->customer_id;
        $data->details = $request->details;
        $data->c_target = $request->cash_id;
        $data->save();
        if ($data) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 30)->where('module_record_id', $data->id)->first();
                if ($cash != null) {
                    $cash->title = $data->title;
                    $cash->date = $data->date;
                    $cash->income = $data->amount;
                    $cash->currency_id = $data->currency_id;
                    $cash->module_id = 30;
                    $cash->type_id = 30;
                    $cash->module_record_id = $data->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Customer Advance";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $data->title;
                    $cash->date = $data->date;
                    $cash->income = $data->amount;
                    $cash->currency_id = $data->currency_id;
                    $cash->module_id = 30;
                    $cash->type_id = 30;
                    $cash->module_record_id = $data->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Customer Advance";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 30)->where('module_record_id', $data->id)->delete();
            }
        }
        $lidger = CustomerLiger::where('transaction_id', 4)
        ->where('module_rid', $data->id)
        ->where('customer_id', $data->customer_id)
        ->where('currency_id', $data->currency_id)
        ->delete();
        $lidger = new CustomerLiger();
        $lidger->customer_id = $data->customer_id;
        $lidger->currency_id = $data->currency_id;
        $lidger->transaction_id = 4;
        $lidger->module_rid = $data->id;
        $lidger->bill_total = 0;
        $lidger->amount = $data->amount;
        $lidger->bill_balance = 0;
        // here we find related customer balance 
        $previouse_balance = CustomerLiger::where('customer_id', $data->customer_id)
            ->where('currency_id', $data->currency_id)
            ->orderBy('id', 'desc')
            ->get()->first();
        $total_balance = 0;
       
        if ($previouse_balance) {
            $previouse_balance = $previouse_balance->total_balance;
            $total_balance = $previouse_balance - $request->amount;
            $previouse_balance;
        } else {
            $total_balance = $total_balance - $data->amount;
        }
        $lidger->total_balance = $total_balance;
        $lidger->date = $data->date;
        $lidger->save();
        session()->flash("msg", "Success!");
        return redirect()->route('customer_advance.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $data = CustomerAdvance::find($id);
        $cash = CashJournal::where('module_id', 30)->where('module_record_id', $id)->delete();
        $lidger = CustomerLiger::where('transaction_id', 4)
            ->where('module_rid', $data->id)
            ->delete();
        $data->delete();
        return back();
    }

    public function report_show()
    {
        $customers = Customer::orderBy('id', 'desc')->get();
        $currencies = currency::all();
        return view('sale.advances.report', compact('customers', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $Customer = Customer::find($customer_id);
        $currency = currency::find($currency_id);
        $data = "";
        if ($customer_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'> Advance Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>All Customers & All Currencies</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Advnace</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advances = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->get();
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->Customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">Advnace</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (currency::all() as $row) {
                    $Advnace = CustomerAdvance::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $Advnace . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'> Advance Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Advnace</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advances = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('currency_id', $currency_id)->get();
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->Customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="4" class="">Advnace</th>';
                $data .= '<th colspan="4" class="">' . $advances->sum('amount') . '</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';

                $data .= '</tr>';
                $data .= '</table>';
            }

        } else {
            if ($currency_id == "all") {
                $advances = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->name Advance Report</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Advnace</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">Advnace</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $Advnace = CustomerAdvance::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $Advnace . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $advances = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->where('currency_id', $currency_id)->get();
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->name Advance Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en currency</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th># Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Advnace</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">' . $advances->sum('amount') . '</th>';
                $data .= ' </tr>';

                $data .= '</table>';
            }

        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $data = CustomerAdvance::Where('invoice_number', $request->number)
                ->get();
        } else if ($request->type_id == 2) {
            $data = CustomerAdvance::Where('title', 'like', '%' . $request->title . '%')
                ->get();
        } else {
            $data = CustomerAdvance::whereBetween('date', [$request->f_date, $request->t_date])
                ->get();
        }

        return view('sale.advances.filter', compact('data'));

    }
}
