<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CompanyAsset;
use App\Models\Currency;
use App\Models\assetAccounts;

class FixedAssetController extends Controller
{
    public function index()
    {
        $assets=CompanyAsset::orderBy('id','desc')->paginate(10);
        return view('journals.assets.index',compact('assets'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $currencies=Currency::all();
        $assets=assetAccounts::all();
        return view('journals.assets.create',compact('currencies','assets'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'type_id' => 'required',
            'department' => 'required',
            'condition' => 'required',
            'quantity' => 'required',
            'price' => 'required',
            'date' => 'required',
           
           
        ]);
        $asset=new CompanyAsset();
        $asset->name=$request->name;
        $asset->type_id=$request->type_id;
        $asset->currency_id=$request->currency_id;
        $asset->condition=$request->condition;
        $asset->departement=$request->department;
        $asset->quantity=$request->quantity;
        $asset->price=$request->price;
        $asset->total=$request->total;
        $asset->model=$request->model;
        $asset->vendor_number=$request->vendor_number;
        $asset->description=$request->description;
        $asset->date=$request->date;

        $date = date("Y-m-d");
        if (request()->hasFile('picture')) {
            $filename = 'picture-' . time() . '-' . request()->file('picture')->getClientOriginalName();
            $path = request()->file('picture')->storeAs('picture/' . $date . '/', $filename, 'public');
        } else {
            $path = $asset->picture;
        }
        if (request()->hasFile('document')) {
            $filename = 'document-' . time() . '-' . request()->file('document')->getClientOriginalName();
            $dpath = request()->file('document')->storeAs('document/' . $date . '/', $filename, 'public');
        } else {
            $dpath = $asset->document;
        }
        $asset->picture = $path;
        $asset->document = $dpath;
        $asset->save();
        session()->flash("msg", "Success!");
        return redirect()->route('company_asset.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $currencies=Currency::all();
        $asset = CompanyAsset::find($id);
        $assets=assetAccounts::all();

        return view('journals.assets.edit',compact('asset','currencies','assets'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $request->validate([
            'name' => 'required',
            'type_id' => 'required',
            'department' => 'required',
            'condition' => 'required',
           
           
        ]);
        $asset=CompanyAsset::find($id);
        $asset->name=$request->name;
        $asset->type_id=$request->type_id;
        $asset->currency_id=$request->currency_id;
        $asset->condition=$request->condition;
        $asset->departement=$request->department;
        $asset->quantity=$request->quantity;
        $asset->price=$request->price;
        $asset->total=$request->total;
        $asset->model=$request->model;
        $asset->vendor_number=$request->vendor_number;
        $asset->description=$request->description;
        $asset->date=$request->date;
        $date = date("Y-m-d");
        if (request()->hasFile('picture')) {
            $filename = 'picture-' . time() . '-' . request()->file('picture')->getClientOriginalName();
            $path = request()->file('picture')->storeAs('picture/' . $date . '/', $filename, 'public');
        } else {
            $path = $asset->picture;
        }
        if (request()->hasFile('document')) {
            $filename = 'document-' . time() . '-' . request()->file('document')->getClientOriginalName();
            $path = request()->file('document')->storeAs('document/' . $date . '/', $filename, 'public');
        } else {
            $path = $asset->document;
        }
        $asset->document = $path;
        $asset->save();
        session()->flash("msg", "Success!");
        return redirect()->route('company_asset.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function report_show()
    {
        return view('journals.assets.report');
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $data = "";
            $data .= "<h6  style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6  style='text-align:center;'>Company Asset Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6  style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Name</th>';
            $data .= '<th>Type</th>';
            $data .= '<th>Model</th>';
            $data .= '<th>Department</th>';
            $data .= '<th>Qty</th>';
            $data .= '<th>Price</th>';
            $data .= '<th>Total</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $company_asset = CompanyAsset::whereBetween('date', [$fDate, $tDate])->orderBy('id', 'desc')->get();
            foreach ($company_asset as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->name . "</td>";
                $data .= "<td>" . $row->type . "</td>";
                $data .= "<td>" . $row->model . "</td>";
                $data .= "<td>" . $row->departement . "</td>";
                $data .= "<td>" . $row->quantity . "</td>";
                $data .= "<td>" . $row->price . "</td>";
                $data .= "<td>" . $row->total . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
            }
            $data.="<tr>";
            $data.="<td colspan='2' style='text-align:;'>Total</td>";
            $data.="<th colspan='7' style='text-align:center; text-width:bold;'>".$company_asset->sum('total')."</th>";
            $data.="</tr>";
            $data .= "</tbody>";
          
            $data .= '</table>';
        

        return $data;
    }
    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $bills = CustomerBill::Where('invoice_number', $request->bill_number)
                ->paginate(10);
        } else if ($request->type_id == 2) {
            $bills = CustomerBill::Where('title', 'like', '%' . $request->title . '%')
                ->paginate(10);
        } else if ($request->type_id == 3) {
            $bills = CustomerBill::Where('grand_total', $request->total)
                ->paginate(10);
        } else if ($request->type_id == 4) {

            $bills = CustomerBill::Where('received', $request->recieved)
                ->paginate(10);
        } else {
            $bills = CustomerBill::WhereBetween('invoice_date', [$request->from_date, $request->to_date])
                ->paginate(10);
        }
        return view('sale.bills.filter', compact('bills'));
    }



 

  
}
