<?php

namespace App\Http\Controllers\configuration;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Scategory;

class SaleCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Scategory = Scategory::orderBy('id','desc')->paginate(10);
        return view('configuration.Scategory.create', compact('Scategory'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Scategory = new Scategory();
        $Scategory->title_en = $request->title_en;
        $Scategory->title_ps = $request->title_ps;
        $Scategory->title_dr = $request->title_dr;
        $Scategory->save();
        if ($Scategory) {
            return redirect()->route('scategories.index')->with('msg', 'Success');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Scategory = Scategory::find($id);
        return view('configuration.Scategory.edit', compact('Scategory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Scategory = Scategory::find($id);
        $Scategory->title_en = $request->title_en;
        $Scategory->title_ps = $request->title_ps;
        $Scategory->title_dr = $request->title_dr;
        $Scategory->save();
        if ($Scategory) {
            return redirect()->route('scategories.index')->with('msg', 'Scategory Type Was Updated');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id)
    {
        $Scategory = Scategory::find($id);
        if ($Scategory->status == 0) {
            Scategory::where('id', $id)->update([
                'status' => 1
            ]);
        }
        if ($Scategory->status == 1) {
            Scategory::where('id', $id)->update([
                'status' => 0
            ]);
        }
        return back()->with('msg', 'Status Was Updated');
    }
}
