<?php

namespace App\Http\Controllers\Vehicle;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Vehicle;
use App\Models\Project;
use App\Models\VehicelRent;

class VehicleActivityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Vehicle::orderBy('id', 'desc')->paginate(20);
        return view('vehicles.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $projects = Project::orderBy('id', 'desc')->where('status', '!=', 3)->get();
        return view('vehicles.create', compact('projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'father_number' => 'required',
            'plate_number' => 'required',
            'engine_number' => 'required',
        ]);
        $data = new Vehicle();
        $data->driver = $request->name;
        $data->driver_father_name = $request->father_number;
        $data->v_model = $request->model;
        $data->pl_number = $request->plate_number;
        $data->en_number = $request->engine_number;
        $data->c_s_date = $request->c_s_date;
        $data->c_e_date = $request->c_e_date;
        $data->contract_amount = $request->c_amount;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('vehicleActivity.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Vehicle::find($id);
        $projects = Project::orderBy('id', 'desc')->where('status', '!=', 3)->get();
        $rents = VehicelRent::where('vehicle_id', $id)->get();
        return view('vehicles.show', compact('data', 'projects', 'rents'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Vehicle::find($id);
        return view('vehicles.edit', compact('data'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'father_number' => 'required',
            'plate_number' => 'required',
            'engine_number' => 'required',
        ]);
        $data = Vehicle::find($id);
        $data->driver = $request->name;
        $data->driver_father_name = $request->father_number;
        $data->v_model = $request->model;
        $data->pl_number = $request->plate_number;
        $data->en_number = $request->engine_number;
        $data->c_s_date = $request->c_s_date;
        $data->c_e_date = $request->c_e_date;
        $data->contract_amount = $request->c_amount;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('vehicleActivity.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $data = Vehicle::find($id);
        $data->delete();
        session()->flash("msg", "Success!");
        return redirect()->back();

    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $data = Vehicle::where('driver', 'like', '%' . $request->driver . '%')->paginate(20);
        }
        if ($request->type_id == 2) {
            $data = Vehicle::where('pl_number', 'like', '%' . $request->plate_number . '%')->paginate(20);
        }
        if ($request->type_id == 2) {
            $data = Vehicle::where('en_number', 'like', '%' . $request->engine_number . '%')->paginate(20);
        }
        return view('vehicles.index', compact('data'));
    }

    public function report_show()
    {
        return view('vehicles.report');
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $project_id = $request->project_id;
        $data = "";
        $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
        $data .= "<h6 style='text-align:center;'>All Documents</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
        $data .= "<h6 style='text-align:center;'>Report</h6>";
        $data .= '<table class="" id="table_style">';
        $data .= '<tr>';
        $data .= '<th>Number</th>';
        $data .= '<th>Start Date</th>';
        $data .= '<th>Close Date</th>';
        $data .= '<th>Vehicle Model</th>';
        $data .= '<th>Plate Number</th>';
        $data .= '<th>Engine Number</th>';
        $data .= '<th>Contract Amount</th>';
        $data .= '</tr>';
        $data .= '<tbody>';
        $i = 1;
        $archive = Vehicle::whereBetween('c_s_date', [$fDate, $tDate])->get();
        foreach ($archive as $row) {
            $data .= "<tr>";
            $data .= "<td>" . $i . "</td>";
            $data .= "<td>" . $row->c_s_date . "</td>";
            $data .= "<td>" . $row->c_e_date . "</td>";
            $data .= "<td>" . $row->v_model . "</td>";
            $data .= "<td>" . $row->pl_number . "</td>";
            $data .= "<td>" . $row->en_number . "</td>";
            $data .= "<td>" . $row->contract_amount . "</td>";
            $data .= "</tr>";
            $i++;
        }
        if ($i == 1) {
            $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
        }
        $data .= "</tbody>";
        $data .= '</table>';
        $data .= '</table>';
        return $data;
    }
}
