<?php

namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Currency;
use App\Models\Supplier;
use App\Models\SupplierAdvance;
use Auth;

class SupplierAdvanceController extends Controller
{
    public function index($id)
    {
        $supplier = Supplier::find($id);
        $advances = SupplierAdvance::where('supplier_id', $id)->orderBy('id','desc')->paginate(10);
        $currencies = Currency::all();
        return view('purchase.suppliers.advances.index', compact('advances', 'supplier', 'currencies'));
    }

    public function create($id)
    {
        $supplier = Supplier::find($id);
        $currencies = Currency::all();
        $invoice_number = SupplierAdvance::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('purchase.suppliers.advances.create', compact('supplier', 'currencies', 'number'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
            'supplier_id' => 'required',
            'invoice_number' => 'required',
        ]);
        $advance = new SupplierAdvance();
        $advance->supplier_id = $request->supplier_id;
        $advance->invoice_number = $request->invoice_number;
        $advance->amount = $request->amount;
        $advance->date = $request->date;
        $advance->title = $request->title;
        $advance->details = $request->details;
        $advance->currency_id = $request->currency_id;
        $advance->ex_rate = $request->ex_rate;
        $advance->status = 1;
        $advance->user_id = Auth::user()->id;
        $advance->save();
        session()->flash("msg", "Success!");
        return redirect()->route('supplier_advance.index', $advance->supplier_id);
    }

    public function edit($id)
    {
        $data = SupplierAdvance::find($id);
        $supplier = Supplier::find($data->supplier_id);
        $currencies = Currency::all();
        return view('purchase.suppliers.advances.edit', compact('data', 'currencies', 'supplier'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
        ]);
        $advance = SupplierAdvance::find($id);
        $advance->supplier_id = $request->supplier_id;
        $advance->invoice_number = $request->invoice_number;
        $advance->amount = $request->amount;
        $advance->date = $request->date;
        $advance->title = $request->title;
        $advance->details = $request->details;
        $advance->currency_id = $request->currency_id;
        $advance->ex_rate = $request->ex_rate;
        $advance->status = 1;
        $advance->user_id = Auth::user()->id;
        $advance->save();
        session()->flash("msg", "Success!");
        return redirect()->route('supplier_advance.index', $request->supplier_id);
    }

    public function delete($id)
    {
        $advance = SupplierAdvance::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function report_show($id)
    {
        $currencies = Currency::all();
        $supplier = Supplier::find($id);
        return view('purchase.suppliers.advances.report', compact('supplier', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $supplier = Supplier::find($supplier_id);

        $currency = Currency::find($currency_id);
        $currencies = Currency::all();
        $data = "";
        if ($currency_id == "all") {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center;'>advance Report</h6>";
            $data .= "<h6 style='text-align:center;'>All Currency Report</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>advance</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $advances = SupplierAdvance::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->get();
            foreach ($advances as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
            $data .= '<th colspan="4" class="">advance</th>';

            $data .= ' </tr>';
            $data .= ' <tr>';
            foreach (Currency::all() as $row) {
                $advance = SupplierAdvance::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                $data .= '<td style="">' . $row->title_en . "/" . $advance . '</td>';
            }
            $data .= '</tr>';
            $data .= '</table>';
        } else {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center;'>advance Report</h6>";
            $data .= "<h6 style='text-align:center;'>$currency->title_en Currency Report</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>advance</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $advances = SupplierAdvance::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->where('currency_id', $currency_id)->get();
            foreach ($advances as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th  rowspan="2">Sub Total</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $advance = SupplierAdvance::where('currency_id', $currency_id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
            $data .= "<td colspan='4'>";
            $data .= $advance;
            $data .= "</td>";
            $data .= '</tr>';
            $data .= '</table>';
        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        $currencies = Currency::all();
        if ($request->type_id == 1) {
            $advances = SupplierAdvance::Where('invoice_number', $request->number)
                ->where('supplier_id', $request->supplier_id)
                ->paginate(10);
        } else {
            $advances = SupplierAdvance::Where('title', 'like', '%' . $request->title . '%')
                ->where('supplier_id', $request->supplier_id)
                ->paginate(10);
        }
        
        $supplier = Supplier::find($request->supplier_id);
        return view('purchase.suppliers.advances.filter', compact('currencies', 'advances', 'supplier'));
    }
}
