<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
class PermissionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
   
    public function index()
    {
        $permission=Permission::orderBy('id','desc')->paginate(10);
        return view('accounts.permission.create',compact('permission'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $permission=Permission::orderBy('id','desc')->paginate(10);
        return view('accounts.permission.create',compact('permission'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $perm=new Permission();
        $perm->name=$request->name;
        $is_saved = $perm->save();
        if ($is_saved){
           
            session()->flash("msg", "Success");
            return redirect()->route('permission.index');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $record=Permission::find($id);
        return view('accounts.permission.edit',compact('record'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $perm=Permission::find($id);
        $perm->name=$request->name;
        $is_saved = $perm->save();
        if ($is_saved){
           
            session()->flash("msg", "Success");
            return redirect()->route('permission.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $perm=Permission::find($id);
        $is_saved = $perm->delete();
        if ($is_saved){
           
            session()->flash("msg", "Success");
            return redirect()->route('permission.index');
        }
    }
}
