<?php

namespace App\Http\Controllers\HR\multiple;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmployeeOverTime;
use App\Models\Employee;
use App\Models\Project;
use Auth;

class EmpOvertimeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = Employee::all();
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        $overtimes = EmployeeOverTime::orderBy('id', 'desc')->paginate(20);
        return view('HR.overtime.index', compact('overtimes', 'employees','projects'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'amount' => 'required',
            'date' => 'required',
            'employee_id' => 'required',
            'hours' => 'required',
        ]);
        $overtime = new EmployeeOverTime();
        $overtime->employee_id = $request->employee_id;
        $overtime->project_id = $request->project_id;
        $overtime->type_id = $request->type_id;
        $overtime->amount = $request->amount;
        $overtime->hourse = $request->hours;
        $overtime->date = $request->date;
        $data = explode('-', $request->date);
        $year = $data[0];
        $month = $data[1];
        $day = $data[2];
        $overtime->year = $year;
        $overtime->month = $month;
        $overtime->day = $day;
        $overtime->status = 1;
        $overtime->user_id = Auth::user()->id;
        $overtime->save();
        session()->flash("msg", "Success!");
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employees = Employee::all();
        $overtime = EmployeeOverTime::find($id);
        $overtimes = EmployeeOverTime::orderBy('id', 'desc')->paginate(20);
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('HR.overtime.edit', compact('overtime', 'employees','overtimes','projects'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'amount' => 'required',
            'date' => 'required',

        ]);
        $overtime = EmployeeOverTime::find($id);
        $overtime->employee_id = $request->employee_id;
        $overtime->project_id = $request->project_id;
        $overtime->type_id = $request->type_id;
        $overtime->amount = $request->amount;
        $overtime->hourse = $request->hours;
        $overtime->date = $request->date;
        $data = explode('-', $request->date);
        $year = $data[0];
        $month = $data[1];
        $day = $data[2];
        $overtime->year = $year;
        $overtime->month = $month;
        $overtime->day = $day;
        $overtime->status = 1;
        $overtime->user_id = Auth::user()->id;
        $overtime->save();
        session()->flash("msg", "Success!");
        return redirect()->route('employee_overtimes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $overtime = EmployeeOverTime::find($id);
        $overtime->delete();
        session()->flash("msg", "Success!");
        return redirect()->route('employee_overtimes.index');
    }

    public function report_show()
    {
        $employees = Employee::all();
        return view('HR.overtime.report', compact('employees'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $employee_id = $request->employee_id;
        $employee = Employee::find($employee_id);
        $data = "";
        if ($employee_id == "all") {
            $data .= "<h6 style='text-align:center'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center'>All Employees overtime Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center'>Print Date" . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Employee</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Hours</th>';
            $data .= '<th>Amount</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $overtimes = EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->get();
            foreach ($overtimes as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->employee->name . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->hourse . "</td>";
                $data .= "<td>" . $row->amount . " </td>";

                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
            }

            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan="">Amount</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $data .= '<td>' . $overtimes->sum('amount') . '</td>';
            $data .= '</tr>';
            $data .= '</table>';
        } else {
            $data .= "<h6 style='text-align:center'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center'>$employee->name overtime Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Hours</th>';
            $data .= '<th>Amount</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $overtimes = EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->where('employee_id', $employee_id)->get();
            foreach ($overtimes as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->hourse . "</td>";
                $data .= "<td>" . $row->amount . " </td>";

                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
            }

            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan="">Amount</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $data .= '<td>' . $overtimes->sum('amount') . '</td>';
            $data .= '</tr>';
            $data .= '</table>';
        }
        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $overtimes = EmployeeOverTime::Where('amount', 'like', '%' . $request->amount . '%')

                ->paginate(10);
        } else {
            $overtimes = EmployeeOverTime::whereBetween('date', [$request->f_date, $request->t_date])

                ->paginate(10);
        }
        $employees = Employee::all();
        return view('HR.overtime.index', compact('overtimes','employees'));
    }
}
