<?php

namespace App\Http\Controllers\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmployeeSalaries;
use App\Models\Employee;
use App\Models\Month;
use App\Models\CashJournal;
use App\Models\Project;
use Illuminate\Support\Facades\Auth;

class EmployeeSalariesController extends Controller
{


  public function index($id)
  {
    $employee = Employee::find($id);
    $salaries = EmployeeSalaries::where('employee_id', $id)->orderBy('id', 'desc')->paginate(20);
    $months = Month::all();
    return view('HR.employees.salary.index', compact('employee', 'salaries', 'months'));
  }
  public function create($id)
  {
    $employee = Employee::find($id);
    $projects=Project::where('status',2)->get();
    return view('HR.employees.salary.create', compact('employee','projects'));
  }

  public function view($id)
  {
    $salary = EmployeeSalaries::find($id);
    return view('HR.employees.salary.show', compact('salary'));
  }
  public function store(Request $request)
  {
    $request->validate([
      'date' => 'required',
      'employee_id' => 'required',
    ]);
    
    $data = explode('-', $request->date);
    $year = $data[0];
    $month = $data[1];
    $day = $data[2];
    $check = EmployeeSalaries::where('employee_id', $request->employee_id)->where('year', $year)->where('month', $request->month_id)->count();
    if ($check != 0) {
      session()->flash("msg", "employee Get There Salary in This Month!");
      return back();
    } else {
      $salary = new EmployeeSalaries();
      $salary->employee_id = $request->employee_id;
      $salary->basic_salary = $request->basic_salary;
      $salary->advance_amount = $request->advance_payment;
      $salary->opsent_days = $request->present_days;
      $salary->opsent_amount = $request->present_amount;
      $salary->overtime_amount = $request->overtime_amount;
      $salary->gross_salary = $request->gross_salary;
      $salary->net_salary = $request->net_salary;
      $salary->date = $request->date;
      $salary->year = $year;
      $salary->month = $request->month_id;
      $salary->day = $day;
      $salary->user_id = Auth::user()->id;
      $salary->c_target = $request->cash_id;
      $salary->status = 0;
      $salary->details = $request->details;
      $salary->save();
      if ($salary) {
        if ($request->cash_id == 1) {
          $cash = new CashJournal();
          $cash->title = "as Salary";
          $cash->date = $salary->date;
          $cash->outgoing = $salary->net_salary;
          $cash->currency_id = 1;
          $cash->ex_rate = 1;
          $cash->module_id = 27;
          $cash->type_id = 27;
          $cash->module_record_id = $salary->id;
          $cash->user_id = Auth::user()->id;
          $cash->details = "Cash Target From Employee Salary";
          $cash->save();
        }
      }
    }
    if ($request->check_value == 'all') {
      session()->flash("msg", "employee Get There Salary in This Month!");
      return redirect()->route('employee_salary.index_all');
    } else {
      session()->flash("msg", "employee Get There Salary in This Month!");
      return redirect()->route('employee_salary.index', $request->employee_id);
    }

  }

  public function edit($id)
  {
    $salary = EmployeeSalaries::find($id);
    return view('HR.employees.salary.edit', compact('salary'));
  }
  public function update(Request $request, $id)
  {
    $data = explode('-', $request->date);
    $year = $data[0];
    $month = $data[1];
    $day = $data[2];

    $salary = EmployeeSalaries::find($id);
    $salary->employee_id = $request->employee_id;
    $salary->basic_salary = $request->basic_salary;
    $salary->advance_amount = $request->advance_payment;
    $salary->opsent_days = $request->present_days;
    $salary->opsent_amount = $request->present_amount;
    $salary->overtime_amount = $request->overtime_amount;
    $salary->gross_salary = $request->gross_salary;
    $salary->net_salary = $request->net_salary;
    $salary->date = $request->date;
    $salary->year = $year;
    $salary->month = $request->month_id;
    $salary->day = $day;
    $salary->user_id = Auth::user()->id;
    $salary->c_target = $request->cash_id;
    $salary->status = 0;
    $salary->details = $request->details;
    $salary->save();
    if ($salary) {
      if ($request->cash_id == 1) {
        $cash = CashJournal::where('module_id', 27)->where('module_record_id', $salary->id)->first();
        if ($cash != null) {
          $cash->title = "as Salary";
          $cash->date = $salary->date;
          $cash->outgoing = $salary->net_salary;
          $cash->currency_id = 1;
          $cash->ex_rate = 1;
          $cash->module_id = 27;
          $cash->type_id = 27;
          $cash->module_record_id = $salary->id;
          $cash->user_id = Auth::user()->id;
          $cash->details = "Cash Target From Employee Salary";
          $cash->save();
        } else {
          $cash = new CashJournal();
          $cash->title = "as Salary";
          $cash->date = $salary->date;
          $cash->outgoing = $salary->net_salary;
          $cash->currency_id = 1;
          $cash->ex_rate = 1;
          $cash->module_id = 27;
          $cash->type_id = 27;
          $cash->module_record_id = $salary->id;
          $cash->user_id = Auth::user()->id;
          $cash->details = "Cash Target From Employee Salary";
          $cash->save();
        }
      } else {
        $cash = CashJournal::where('module_id', 27)->where('module_record_id', $salary->id)->delete();
      }
    }

    session()->flash("msg", "Employee Salary Has Been Updated!");
    return redirect()->route('employee_salary.index', $request->employee_id);
  }
  public function report_show($id)
  {
    return view('HR.employees.salary.report', compact('id'));
  }

  public function report_find(Request $request)
  {
    $bname = \App\Models\Info::find(1)->business_name;
    $fDate = $request->fromDate;
    $tDate = $request->toDate;
    $f_data = explode('-', $request->fromDate);
    $f_year = $f_data[0];
    $f_month = $f_data[1];
    $t_data = explode('-', $request->toDate);
    $t_year = $t_data[0];
    $t_month = $t_data[1];
    $employee_id = $request->employee_id;
    $employee = Employee::find($employee_id);
    $data = "";

    $salary = EmployeeSalaries::whereBetween('year', [$f_year, $t_year])->whereBetween('month', [$f_month, $t_month])->where('employee_id', $employee_id)->get();
    $data .= "<h6 style='text-align:center'>" . $bname . "</h6>";
    $data .= "<h6 style='text-align:center'>$employee->name Salary Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
    $data .= '<table class="" id="table_style">';
    $data .= '<tr>';
    $data .= '<th>Number</th>';
    $data .= '<th>B-S</th>';
    $data .= '<th>Overtime</th>';
    $data .= '<th>Attendance</th>';
    $data .= '<th>Attend Amount</th>';
    $data .= '<th>G-S</th>';
    $data .= '<th>Advance</th>';
    $data .= '<th>N-S</th>';
    $data .= '</tr>';
    $data .= '<tbody>';
    $i = 1;
    foreach ($salary as $row) {
      $data .= "<tr>";
      $data .= "<td>" . $i . "</td>";
      $data .= "<td>" . $row->basic_salary . "</td>";
      $data .= "<td>" . $row->overtime_amount . " </td>";
      $data .= "<td>" . $row->opsent_days . "</td>";
      $data .= "<td>" . $row->opsent_amount . "</td>";
      $data .= "<td>" . $row->gross_salary . "</td>";
      $data .= "<td>" . $row->advance_amount . "</td>";
      $data .= "<td>" . $row->net_salary . "</td>";
      $data .= "</tr>";
      $i++;
    }
    if ($i == 1) {
      $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
    }
    $data .= "</tbody>";
    $data .= '</table>';
    $data .= '</table>';
    $data .= '<table class="">';
    $data .= ' <tr>';
    $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
    $data .= '<th colspan="">Gross Total</th>';
    $data .= ' </tr>';
    $data .= ' <tr>';
    $data .= '<td>' . $salary->sum('gross_salary') . '</td>';
    $data .= '</tr>';
    $data .= '</table>';

    return $data;
  }


  public function filter_find(Request $request)
  {
    $employee = Employee::find($request->employee_id);


    $salaries = EmployeeSalaries::where('employee_id', $request->employee_id)->where('month', $request->month)->where('year', $request->year)->orderBy('id', 'desc')->paginate(10);
    $months = Month::all();
    return view('HR.employees.salary.index', compact('employee', 'salaries', 'months'));
  }


}
