<?php

namespace App\Http\Controllers\Archive;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Archive;
use App\Models\Project;

class ArchiveController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Archive::orderBy('id', 'desc')->paginate(20);
        return view('archive.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('archive.create', compact('projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'document_number' => 'required',
            'file' => 'required',
            'title' => 'required',
        ]);

        $data = new Archive();
        $data->title = $request->title;
        $data->type_id = $request->type_id;
        $data->project_id = $request->project_id;
        $data->document_number = $request->document_number;
        $data->sadera_number = $request->sadera_number;
        $data->wareda_number = $request->wareda_number;
        $data->file_number = $request->file_number;
        $data->carton_number = $request->carton_number;
        $data->date = $request->date;
        $data->details = $request->details;
        $date = date("Y-m-d");
        if (request()->hasFile('file')) {
            $filename = 'old_archive-' . time() . '-' . request()->file('file')->getClientOriginalName();
            $path = request()->file('file')->storeAs('old_archive/' . $date . '/', $filename, 'public');
        } else {
            $path = "old_archive/noimage.jpg";
        }
        $data->attachment = $path;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('archive.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Archive::find($id);
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('archive.edit', compact('data', 'projects'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'document_number' => 'required',
            'title' => 'required',
        ]);

        $data = Archive::find($id);
        $data->title = $request->title;
        $data->project_id = $request->project_id;
        $data->type_id = $request->type_id;
        $data->document_number = $request->document_number;
        $data->sadera_number = $request->sadera_number;
        $data->wareda_number = $request->wareda_number;
        $data->file_number = $request->file_number;
        $data->carton_number = $request->carton_number;
        $data->date = $request->date;
        $data->details = $request->details;
        $date = date("Y-m-d");
        if (request()->hasFile('file')) {
            $filename = 'old_archive-' . time() . '-' . request()->file('file')->getClientOriginalName();
            $path = request()->file('file')->storeAs('old_archive/' . $date . '/', $filename, 'public');
        } else {
            $path = "old_archive/noimage.jpg";
        }
        $data->attachment = $path;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('archive.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $data = Archive::find($id);
        $data->delete();
        session()->flash("msg", "Success!");
        return redirect()->back();
    }

    public function report_show()
    {
        return view('archive.report');
    }
    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $project_id = $request->project_id;
        $data = "";
        $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
        $data .= "<h6 style='text-align:center;'>All Documents</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
        $data .= "<h6 style='text-align:center;'>Report</h6>";
        $data .= '<table class="" id="table_style">';
        $data .= '<tr>';
        $data .= '<th>Number</th>';
        $data .= '<th>Date</th>';
        $data .= '<th>Project</th>';
        $data .= '<th>Document Number</th>';
        $data .= '</tr>';
        $data .= '<tbody>';
        $i = 1;
        $archive = Archive::whereBetween('date', [$fDate, $tDate])->get();
        foreach ($archive as $row) {
            $data .= "<tr>";
            $data .= "<td>" . $i . "</td>";
            $data .= "<td>" . $row->date . "</td>";
            $data .= "<td>" . $row->project->name . "</td>";
            $data .= "<td>" . $row->document_number . "</td>";
            $data .= "</tr>";
            $i++;
        }
        if ($i == 1) {
            $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
        }
        $data .= "</tbody>";
        $data .= '</table>';
        $data .= '</table>';
        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $data = Archive::Where('document_number', 'like', "%" . $request->number . "%")
                ->paginate(10);
        } else{
            $data = Archive::Where('title', 'like', "%" . $request->amount . "%")
                ->paginate(10);
        } 
        return view('archive.filter', compact('data'));

    }
}
