<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SSubCategory;
use App\Models\Scategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\Stock;
use App\Models\PurchaseStock;
use App\Models\Employee;
use App\Models\EmployeeAdvance;
use App\Models\EmployeeOverTime;
use App\Models\EmployeeAttendance;
use App\Models\ExchangeProcess;
use App\Models\p_sub_category;
class AjaxController extends Controller
{
    public function get_category(Request $request)
    {
        $record = SSubCategory::where('category_id', $request->p_category)->get();
        $data = "";
        if ($record->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            foreach ($record as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->title_en . '</option>';
            }
        }
        return $data;
    }
    public function get_category_other(Request $request)
    {
        $record = SSubCategory::where('category_id', $request->cat_id)->get();
        $data = "";
        if ($record->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            $data .= '<option value="">Choose</option>';

            foreach ($record as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->title_en . '</option>';
            }
        }
        return $data;
    }
    public function get_stock(Request $request)
    {
        $cat_id = $request->cat_id;
        $weight_id = $request->weight_id;
        if ($cat_id != "" && $weight_id == "") {

            $stock = Stock::where('cat_id', $cat_id)->where('qty', '!=', 0)->get();
        } else if ($cat_id == "" && $weight_id != "") {
            $stock = Stock::where('weight_id', $weight_id)->where('qty', '!=', 0)->get();
        } else {
            $stock = Stock::where('cat_id', $cat_id)
                ->where('weight_id', $weight_id)->where('qty', '!=', 0)->get();
        }

        $data = "";
        if ($stock->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            $data .= '<option value="">Choose Stock</option>';
            foreach ($stock as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->qty . " / " . $row->sub_category->title_en . " / " . $row->unit->title_en . " / " . $row->location->title_ps . '</option>';
            }
        }
        return $data;
    }

    // for some how need to find stock by category 

    public function get_stock_by_category(Request $request)
    {
        $cat_id = $request->cat_id;
        $sub_cat_id = $request->sub_cat_id;
        $stock=Stock::where('cat_id',$request->cat_id)->where('sub_cat_id',$request->sub_cat_id)->where('qty', '!=', 0)->get();
        $data = "";
        if ($stock->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            $data .= '<option value="">Choose Stock</option>';
            foreach ($stock as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->qty . " / " . $row->weight->title_en . " / " . $row->unit->title_en . " / " . $row->location->title_ps . '</option>';
            }
        }
        return $data;
    }
    public function get_stock_attribute(Request $request)
    {
        $stock = Stock::find($request->stock_id);
        $data = [
            'cat_id' => $stock->cat_id,
            'scat_id' => $stock->sub_cat_id,
            'weight_id' => $stock->weight_id,
            'unit_id' => $stock->unit_id,
            'qty' => $stock->qty,
            'cpi' => $stock->cpi,
            'spi' => $stock->spi,
            'stock_id' => $stock->id,
        ];
        return $data;
    }
    public function get_emp_data_for_salary(Request $request)
    {

        $date = $request->date;
        $month_id = $request->month_id;
        $employee_id = $request->employee_id;
        $data = explode('-', $date);
        $year = $data[0];
        $overtime = EmployeeOverTime::where('employee_id', $employee_id)
            ->where('year', $year)
            ->where('month', $month_id)
            ->sum('amount');
        $advance = EmployeeAdvance::where('employee_id', $employee_id)
            ->where('year', $year)
            ->where('month', $month_id)
            ->sum('payment');
        $opsent_days = EmployeeAttendance::where('employee_id', $employee_id)
            ->where('year', $year)
            ->where('month', $month_id)
            ->where('status', 2)
            ->count();
        $present_days = EmployeeAttendance::where('employee_id', $employee_id)
            ->where('year', $year)
            ->where('month', $month_id)
            ->where('status', 1)
            ->count();
        $basic_salary = Employee::find($employee_id)->basic_salary;

        $data = [
            'overtime' => $overtime,
            'advance' => $advance,
            'basic_salary' => $basic_salary,
            'opsent_days' => $opsent_days,
            'present_days' => $present_days,
        ];
        return $data;
    }
    public function get_basic_salary_for_overtime(Request $request)
    {
        $employee_id = $request->employee_id;
        $basic_salary = Employee::find($employee_id)->basic_salary;
        $data = [
            'basic_salary' => $basic_salary,
        ];
        return $data;
    }
    public function load_stock_for_return(Request $request)
    {
        $cats_id = $request->cats_id;
        $wieght_id = $request->wieght_id;
        $stock = Stock::where('cat_id', $cats_id)
            ->where('weight_id', $wieght_id)->where('qty', '!=', 0)->get();
        $data = "";
        if ($stock->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            $data .= '<option value="">Choose Stock</option>';
            foreach ($stock as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->quantity . ' QTY  in stock ' . $row->category->title_en . ' ' . $row->sub_category->title_en . '</option>';
            }
        }
        return $data;

    }
    public function find_stock_attribute(Request $request)
    {
        $stock = Stock::find($request->stock_id);
        $data = [
            'cat_id' => $stock->cat_id,
            'scat_id' => $stock->scat_id,
            'unit_id' => $stock->unit_id,
            'qty' => $stock->qty,
            'cost_price' => $stock->cpi,
            'sale_price' => $stock->spi,
        ];
        return $data;
    }
    // process for row stock 
    public function rget_stock(Request $request)
    {
        $cat_id = $request->rcat_id;
        $unit_id = $request->runit_id;
        if ($cat_id != "" && $unit_id == "") {
             $stock = PurchaseStock::where('cat_id', $cat_id)
                ->where('qty', '!=', 0)
                ->get();
        } else if ($unit_id != "" && $cat_id == "") {
            $stock = PurchaseStock::where('unit_id', $unit_id)
                ->where('qty', '!=', 0)
                ->get();
        } else {
            $stock = PurchaseStock::where('cat_id', $cat_id)
                ->where('unit_id', $unit_id)
                ->where('qty', '!=', 0)
                ->get();
        }
        $data = "";
        if ($stock->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            $data .= '<option value="">Choose Stock</option>';
            foreach ($stock as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->qty . "/" . $row->category->title_en . "/" . $row->sub_category->title_en . '</option>';
            }
        }
        return $data;
    }
    public function rget_stock_attribute(Request $request)
    {
        $stock = PurchaseStock::find($request->rstock_id);
        $data = [
            'cat_id' => $stock->cat_id,
            'unit_id' => $stock->unit_id,
            'qty' => $stock->qty,
            'cpi' => $stock->cpi,
            'spi' => $stock->spi,
            'stock_id' => $stock->id,
        ];
        return $data;
    }

    public function get_row_stock_value(Request $request)
    {
        $stock = PurchaseStock::where('cat_id', $request->cat_id)->where('scat_id', $request->scat_id)->where('unit_id', $request->unit_id)->sum('qty');
        return $stock;
    }

    public function get_ex_rate(Request $request)
    {
        $ex_process = ExchangeProcess::where('currency_id', $request->currency_id)->first();
        $value = $ex_process->rate_of_af;
        return $value;
    }

    public function row_category(Request $request)
    {
        $category = p_sub_category::where('cat_id', $request->cat_id)->get();
        $data = "";
        if ($category->count() == 0) {
            $data .= '<option value="">No Found</option>';
        } else {
            foreach ($category as $row) {
                $data .= '<option value="' . $row->id . '">' . $row->title_en . '</option>';
            }
        }
        return $data;
    }
}
